/*
 * Decompiled with CFR 0.152.
 */
package javaprinter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javaprinter.OperationMode;
import javaprinter.json.Config;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.event.PrintJobAdapter;
import javax.print.event.PrintJobEvent;

public class ReceiptCupsDevice {
    public static boolean printDevice(Config config, byte[] content, OperationMode opMode) {
        System.out.println("Starting CUPS print");
        try {
            String printerName = opMode.getCupsPrintername();
            ReceiptCupsDevice.print(printerName, content);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private static void print(String printerName, byte[] content) throws Exception {
        PrintService service = ReceiptCupsDevice.getNamedPrinter(printerName);
        if (service == null) {
            System.out.println("Can't find a printer with specified attributes");
            return;
        }
        ReceiptCupsDevice.printToService(service, content);
        System.out.println("Printed to " + service.getName());
    }

    private static PrintService getNamedPrinter(String name) {
        PrintService[] services = PrintServiceLookup.lookupPrintServices(null, null);
        if (services.length > 0) {
            if (name == null) {
                return services[0];
            }
            int i = 0;
            while (i < services.length) {
                if (services[i].getName().equals(name)) {
                    return services[i];
                }
                ++i;
            }
        }
        return null;
    }

    private static void printToService(PrintService service, byte[] content) throws IOException, Exception {
        DocFlavor.INPUT_STREAM flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
        ByteArrayInputStream is = new ByteArrayInputStream(content);
        SimpleDoc doc = new SimpleDoc(is, flavor, null);
        DocPrintJob job = service.createPrintJob();
        job.addPrintJobListener(new PrintJobAdapter(){

            @Override
            public void printJobCompleted(PrintJobEvent e) {
                System.out.println("Print job complete");
                System.exit(0);
            }

            @Override
            public void printDataTransferCompleted(PrintJobEvent e) {
                System.out.println("Document transferred to printer");
            }

            @Override
            public void printJobRequiresAttention(PrintJobEvent e) {
                System.err.println("Print job requires attention - out of paper?");
            }

            @Override
            public void printJobFailed(PrintJobEvent e) {
                System.err.println("Print job failed");
            }
        });
        job.print(doc, null);
    }
}

