/*
 * Decompiled with CFR 0.152.
 */
package javaprinter;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import javaprinter.json.Config;
import javax.usb.UsbClaimException;
import javax.usb.UsbConfiguration;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbEndpoint;
import javax.usb.UsbEndpointDescriptor;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbInterface;
import javax.usb.UsbInterfacePolicy;
import javax.usb.UsbNotActiveException;
import javax.usb.UsbNotOpenException;
import javax.usb.UsbPipe;
import javax.usb.UsbServices;
import javax.usb.event.UsbPipeDataEvent;
import javax.usb.event.UsbPipeErrorEvent;
import javax.usb.event.UsbPipeListener;

public class ReceiptUsbDevice {
    public static void dump() throws UsbException {
        UsbServices services = UsbHostManager.getUsbServices();
        System.out.println("USB Service Implementation: " + services.getImpDescription());
        System.out.println("Implementation version: " + services.getImpVersion());
        System.out.println("Service API version: " + services.getApiVersion());
        System.out.println();
    }

    private static boolean simulatePrint(byte[] content) {
        String out = "";
        int i = 0;
        while (i < content.length) {
            byte aCharVal = content[i];
            if (aCharVal >= 32 && aCharVal <= 127) {
                out = String.valueOf(out) + (char)aCharVal;
            }
            if (aCharVal == 13 || aCharVal == 10) {
                out = String.valueOf(out) + "\n";
            }
            ++i;
        }
        System.out.println(out);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean printDevice(Config config, byte[] content, boolean asyncUsb, boolean allowBigPackets) throws UsbClaimException, UsbNotActiveException, UsbDisconnectedException, UsbException {
        boolean ok = true;
        String vendorIdHex = config.vendorid;
        String productIdHex = config.productid;
        UsbServices services = UsbHostManager.getUsbServices();
        UsbHub device = services.getRootUsbHub();
        short vendorId = (short)Integer.parseInt(vendorIdHex, 16);
        short productId = (short)Integer.parseInt(productIdHex, 16);
        UsbDevice usbDev = null;
        if (config.useeveryprintdevice == 1) {
            short epsonVendorId;
            usbDev = ReceiptUsbDevice.findPrintDevice(device);
            if (usbDev == null && (usbDev = ReceiptUsbDevice.findDevice(device, epsonVendorId = (short)Integer.parseInt("04b8", 16), (short)Integer.parseInt("0202", 16))) == null) {
                usbDev = ReceiptUsbDevice.findDevice(device, epsonVendorId, (short)Integer.parseInt("0e20", 16));
            }
        } else {
            usbDev = ReceiptUsbDevice.findDevice(device, vendorId, productId);
        }
        if (usbDev == null) {
            System.err.println("Cannot find a receipt printer - cannot print");
            return false;
        }
        UsbInterface iface = ReceiptUsbDevice.getUsbInterface(usbDev);
        if (iface == null) {
            System.err.println("Cannot find a receipt printer - cannot print");
            return false;
        }
        iface.claim(new UsbInterfacePolicy(){

            public boolean forceClaim(UsbInterface usbInterface) {
                return true;
            }
        });
        try {
            try {
                ReceiptUsbDevice.sendToUsb(iface, content, asyncUsb, allowBigPackets);
                return ok;
            }
            catch (UsbNotOpenException e) {
                e.printStackTrace();
                ok = false;
                if (asyncUsb) return ok;
                iface.release();
                return ok;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                ok = false;
                if (asyncUsb) return ok;
                iface.release();
                return ok;
            }
        }
        finally {
            if (!asyncUsb) {
                iface.release();
            }
        }
    }

    public static UsbDevice findDevice(UsbHub hub, short vendorId, short productId) {
        for (UsbDevice device : hub.getAttachedUsbDevices()) {
            UsbDeviceDescriptor desc = device.getUsbDeviceDescriptor();
            if (desc.idVendor() == vendorId && desc.idProduct() == productId) {
                return device;
            }
            if (!device.isUsbHub() || (device = ReceiptUsbDevice.findDevice((UsbHub)device, vendorId, productId)) == null) continue;
            return device;
        }
        return null;
    }

    public static UsbDevice findPrintDevice(UsbHub hub) {
        for (UsbDevice device : hub.getAttachedUsbDevices()) {
            if (device == null) continue;
            UsbInterface usbInterf = ReceiptUsbDevice.getUsbInterface(device);
            if (usbInterf.getUsbInterfaceDescriptor().bInterfaceClass() == 7) {
                return device;
            }
            if (!device.isUsbHub() || (device = ReceiptUsbDevice.findPrintDevice((UsbHub)device)) == null) continue;
            return device;
        }
        return null;
    }

    private static UsbInterface getUsbInterface(UsbDevice usbDev) {
        UsbConfiguration configuration = usbDev.getActiveUsbConfiguration();
        List usbInterfaces = configuration.getUsbInterfaces();
        for (UsbInterface aUsbInterface : usbInterfaces) {
            if (!aUsbInterface.isActive()) continue;
            return aUsbInterface;
        }
        return null;
    }

    private static void sendToUsb(final UsbInterface iface, byte[] content, boolean asyncUsb, boolean allowBigPackets) throws UsbNotActiveException, UsbNotOpenException, UsbDisconnectedException, UsbException, UnsupportedEncodingException {
        byte outEndPointAddr = ReceiptUsbDevice.getOutEndpoint(iface);
        System.out.println("Endpoint: " + outEndPointAddr);
        UsbEndpoint endpoint = iface.getUsbEndpoint(outEndPointAddr);
        UsbPipe pipe = endpoint.getUsbPipe();
        if (asyncUsb) {
            pipe.addUsbPipeListener(new UsbPipeListener(){

                public void errorEventOccurred(UsbPipeErrorEvent event) {
                    UsbException error = event.getUsbException();
                    System.err.println("An error occured with asynchronous transfer" + error.getMessage());
                    try {
                        iface.release();
                    }
                    catch (UsbDisconnectedException | UsbException | UsbNotActiveException e) {
                        e.printStackTrace();
                    }
                }

                public void dataEventOccurred(UsbPipeDataEvent event) {
                    byte[] data = event.getData();
                    System.out.println("Bytes sent: " + event.getActualLength());
                    try {
                        iface.release();
                    }
                    catch (UsbDisconnectedException | UsbException | UsbNotActiveException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        pipe.open();
        try {
            if (!asyncUsb) {
                int sent = 0;
                if (allowBigPackets) {
                    sent = pipe.syncSubmit(content);
                } else {
                    int packageSize = 4;
                    int written = 0;
                    int len = content.length;
                    while (written < len) {
                        int size = Math.min(len - written, packageSize);
                        byte[] contentToSend = Arrays.copyOfRange(content, written, written + size);
                        sent += pipe.syncSubmit(contentToSend);
                        if ((written += contentToSend.length) > len) break;
                    }
                }
                System.out.println(String.valueOf(sent) + " bytes sent");
            } else {
                pipe.asyncSubmit(content);
            }
        }
        finally {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            pipe.close();
        }
    }

    private static byte getOutEndpoint(UsbInterface iface) {
        for (UsbEndpoint endpoint : iface.getUsbEndpoints()) {
            if (endpoint.getDirection() != 0) continue;
            UsbEndpointDescriptor descr = endpoint.getUsbEndpointDescriptor();
            return descr.bEndpointAddress();
        }
        return 0;
    }

    private static byte[] arraymerge(byte[] one, byte[] two) {
        byte[] combined = new byte[one.length + two.length];
        System.arraycopy(one, 0, combined, 0, one.length);
        System.arraycopy(two, 0, combined, one.length, two.length);
        return combined;
    }
}

