/*
 * Decompiled with CFR 0.152.
 */
package javaprinter.customreceipt;

import java.util.ArrayList;
import java.util.List;
import javaprinter.customreceipt.Layoutfield;

public class TemplateLine {
    Layoutfield[] layoutFields = new Layoutfield[0];

    public TemplateLine(String templateLine) {
        String[] parts = templateLine.split(";");
        ArrayList<Layoutfield> fields = new ArrayList<Layoutfield>();
        int i = 0;
        while (i < parts.length) {
            if (parts[i].length() > 0) {
                fields.add(new Layoutfield(parts[i]));
            }
            ++i;
        }
        this.layoutFields = new Layoutfield[fields.size()];
        fields.toArray(this.layoutFields);
    }

    private int getSumFixedLength() {
        int fixedLengths = 0;
        int i = 0;
        while (i < this.layoutFields.length) {
            Layoutfield field = this.layoutFields[i];
            if (field.isFixedLength) {
                fixedLengths += field.plength;
            }
            ++i;
        }
        return fixedLengths;
    }

    private int getCountOfVariableLengthFieldsIgnoreWide() {
        int count = 0;
        int i = 0;
        while (i < this.layoutFields.length) {
            Layoutfield field = this.layoutFields[i];
            if (!field.isFixedLength) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private int getCountOfVariableLengthFields() {
        int count = 0;
        int i = 0;
        while (i < this.layoutFields.length) {
            Layoutfield field = this.layoutFields[i];
            if (!field.isFixedLength) {
                ++count;
                if (field.isWide) {
                    ++count;
                }
            }
            ++i;
        }
        return count;
    }

    public List calcVariableSpace(int totalLength) {
        ArrayList<Integer> varLengths = new ArrayList<Integer>();
        int variableFieldsCount = this.getCountOfVariableLengthFieldsIgnoreWide();
        int fixedLength = this.getSumFixedLength();
        int freeSpace = totalLength - fixedLength;
        if (variableFieldsCount == 0) {
            return varLengths;
        }
        int equivalentSpaces = freeSpace / variableFieldsCount;
        int i = 0;
        while (i < variableFieldsCount - 1) {
            varLengths.add(equivalentSpaces);
            ++i;
        }
        int space = totalLength - fixedLength - (variableFieldsCount - 1) * equivalentSpaces;
        if (space <= 0) {
            space = 1;
        }
        varLengths.add(space);
        return varLengths;
    }
}

