/*
 * Decompiled with CFR 0.152.
 */
package javaprinter.genutils;

import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class GenUtils {
    public static byte[] lf_byte = new byte[]{10};

    public static byte[] str2bytes(String str) {
        try {
            byte[] ascii = str.getBytes("Cp437");
            return ascii;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] MergeArrays(byte[] ... arrays) {
        int arrCount = 0;
        int count = 0;
        byte[][] byArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] array = byArray[n2];
            ++arrCount;
            count += array.length;
            ++n2;
        }
        byte[] mergedArray = new byte[count];
        int start = 0;
        byte[][] byArray2 = arrays;
        int n3 = arrays.length;
        int n4 = 0;
        while (n4 < n3) {
            byte[] array = byArray2[n4];
            System.arraycopy(array, 0, mergedArray, start, array.length);
            start += array.length;
            ++n4;
        }
        return mergedArray;
    }

    public static String cutText(String txt, int length) {
        return txt.substring(0, Math.min(length, txt.length()));
    }

    public static String PadRight(String s, int n) {
        return String.format("%1$-" + n + "s", s);
    }

    public static String PadLeft(String s, int n) {
        return String.format("%1$" + n + "s", s);
    }

    public static Calendar getCal(String year, String month, String day, String hour, String minute) {
        int y = Integer.parseInt(year);
        int m = Integer.parseInt(month);
        int d = Integer.parseInt(day);
        int h = Integer.parseInt(hour);
        int min = Integer.parseInt(minute);
        Calendar cal = Calendar.getInstance();
        cal.set(1, y);
        cal.set(2, m - 1);
        cal.set(5, d);
        cal.set(11, h);
        cal.set(12, min);
        return cal;
    }

    public static String calToStr(Calendar cal) {
        Date time = cal.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat();
        return formatter.format(time);
    }

    public static String PadBoth(String source, char c, int length) {
        int spaces = length - source.length();
        int padLeft = spaces / 2 + source.length();
        return GenUtils.PadRight(GenUtils.PadLeft(source, padLeft), length);
    }

    public static byte[] createNote(String text, int length, boolean doCenter) {
        text = text.replace("\r", "");
        String[] textlines = text.split("\n");
        byte[] lines = new byte[]{};
        int i = 0;
        while (i < textlines.length) {
            String aLine = GenUtils.cutText(textlines[i], length);
            byte[] aByteLine = GenUtils.str2bytes(GenUtils.PadRight(aLine, length));
            if (doCenter) {
                aByteLine = GenUtils.str2bytes(GenUtils.PadBoth(aLine, ' ', length));
            }
            lines = GenUtils.MergeArrays(lines, aByteLine, lf_byte);
            ++i;
        }
        return lines;
    }

    public static byte[] createHostPart(int length) {
        String txt = "\n\nAngaben zum Nachweis der H\u00f6he\nund der betrieblichen\nVeranlassung von\nBewirtungsaufwendungen\n(Par. 4 Abs. 5 Ziff. 2 EStG)\n\n";
        txt = String.valueOf(txt) + "Tag der Bewirtung:\n\n\n";
        txt = String.valueOf(txt) + "Ort der Bewirtung:\n\n\n";
        txt = String.valueOf(txt) + "Bewirtete Person(en):\n\n\n\n\n\n";
        txt = String.valueOf(txt) + "Anlass der Bewirtung:\n\n\n\n\n\n\n";
        txt = String.valueOf(txt) + "Ort, Datum        Unterschrift\n\n";
        return GenUtils.createNote(txt, length, false);
    }

    public static byte[] int2byteArray(int[] intArray) {
        byte[] result = new byte[intArray.length];
        int i = 0;
        while (i < intArray.length) {
            result[i] = (byte)intArray[i];
            ++i;
        }
        return result;
    }

    public static String formatPrice(String aVal, String decpoint) {
        double val = Double.parseDouble(aVal);
        return String.format("%.2f", val).replace(".", decpoint);
    }
}

