/*
 * Decompiled with CFR 0.152.
 */
package javaprinter.json.receipt;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javaprinter.OperationMode;
import javaprinter.json.Config;
import javaprinter.logo.LogoPrinter;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;

public class TicketEntry {
    public String typeofentry;
    public String content;

    public byte[] getBytesFromContent(Config config, OperationMode opMode) {
        if (this.typeofentry.compareToIgnoreCase("bytes") == 0) {
            return this.getBytesFromIntegerString();
        }
        if (this.typeofentry.compareToIgnoreCase("img") == 0) {
            String[] intParts = this.content.split(",");
            int imgtype = Integer.parseInt(intParts[0]);
            int addinfo = 0;
            if (intParts.length > 1) {
                addinfo = Integer.parseInt(intParts[1]);
            }
            int scale = 100;
            if (intParts.length > 2) {
                scale = Integer.parseInt(intParts[2]);
            }
            return this.getBytesFromImg(imgtype, addinfo, scale, config, opMode);
        }
        return new byte[0];
    }

    private byte[] getBytesFromIntegerString() {
        String[] parts = this.content.split(",");
        byte[] out = new byte[parts.length];
        int i = 0;
        while (i < parts.length) {
            String anIntegerString = parts[i];
            if (anIntegerString.compareToIgnoreCase("") != 0) {
                int intval = Integer.parseInt(anIntegerString);
                out[i] = (byte)intval;
            }
            ++i;
        }
        return out;
    }

    private byte[] getBytesFromImg(int imgtype, int addinfo, int scale, Config config, OperationMode opMode) {
        URL url = null;
        try {
            url = new URL(String.valueOf(config.baseurl) + "/php/contenthandler.php?module=printqueue&command=getTicketPng&imgtype=" + imgtype + "&addinfo=" + addinfo);
        }
        catch (MalformedURLException e) {
            return new byte[0];
        }
        try {
            URLConnection uc = url.openConnection();
            uc.setRequestProperty("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])(String.valueOf(config.baseusername) + ":" + config.basepass).getBytes())));
            BufferedImage img = ImageIO.read(uc.getInputStream());
            LogoPrinter lp = new LogoPrinter();
            double realscale = config.logoscale * (double)scale / 100.0;
            if (img != null) {
                byte[] out = lp.getImageAsBytes(img, realscale, config.printersize, opMode.getImageLineSpacing(), opMode.getImageLineFeed());
                return out;
            }
        }
        catch (IOException e) {
            return new byte[0];
        }
        return new byte[0];
    }
}

