/*
 * Decompiled with CFR 0.152.
 */
package tseconnector.commands;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.secureflashcard.wormapi.WormAuthenticationFailedException;
import com.secureflashcard.wormapi.WormError;
import com.secureflashcard.wormapi.WormException;
import com.secureflashcard.wormapi.WormExportTarCallback;
import com.secureflashcard.wormapi.WormInformation;
import com.secureflashcard.wormapi.WormInitializationState;
import com.secureflashcard.wormapi.WormStore;
import com.secureflashcard.wormapi.WormUserId;
import com.sun.net.httpserver.HttpExchange;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Locale;
import tseconnector.ITseStatus;
import tseconnector.commands.BaseTseCommand;
import tseconnector.commands.CommandResult;
import tseconnector.commands.TseCmdExecutor;
import tseconnector.commands.TseTarExportCallback;

public class TseAdminCommand
extends BaseTseCommand {
    public byte[] puk;
    @JsonIgnore
    public static String correctPass = "";
    @JsonIgnore
    private final String credseed = "SwissbitSwissbit";

    public String toString() {
        return "Tsecmd [pass=" + this.pass + ", pin=" + Arrays.toString(this.pin) + ", puk=" + Arrays.toString(this.puk) + ", cmd=" + this.cmd + "]";
    }

    @Override
    public CommandResult doCmd(ITseStatus iTseStatus) {
        if (this.cmd.compareTo("factory_reset") == 0) {
            return this.setup(iTseStatus, true);
        }
        if (this.cmd.compareTo("setup") == 0) {
            return this.setup(iTseStatus, false);
        }
        if (this.cmd.compareTo("getinfo") == 0) {
            return this.infoTask(null);
        }
        if (this.cmd.compareTo("decom") == 0) {
            return this.decom(this.clientid);
        }
        if (this.cmd.compareTo("exportlocal") == 0) {
            return this.export_to_local_tmp(iTseStatus);
        }
        if (this.cmd.compareTo("exportdownload") == 0) {
            return this.exportdownload(this.t);
        }
        if (this.cmd.compareTo("exportdownloadlastyear") == 0) {
            return this.exportdownloadlastyear(this.t, this.clientid);
        }
        if (this.cmd.compareTo("forceselftest") == 0) {
            return this.selftest(iTseStatus, true);
        }
        if (this.cmd.compareTo("selftest") == 0) {
            return this.selftest(iTseStatus, false);
        }
        if (this.cmd.compareTo("getlog") == 0) {
            return TseAdminCommand.getlog();
        }
        if (this.cmd.compareTo("check") == 0) {
            return this.check(iTseStatus);
        }
        if (this.cmd.compareTo("userunblock") == 0) {
            return this.userunblock(iTseStatus);
        }
        return new CommandResult(false, "No valid command sent: " + this.cmd);
    }

    private CommandResult selftest(ITseStatus iTseStatus, boolean bl) {
        return TseCmdExecutor.selftest(iTseStatus, bl, this.mountPoint, this.clientid, logger, this.pin);
    }

    private CommandResult decom(String string) {
        return TseCmdExecutor.decom(this.mountPoint, string, logger);
    }

    public CommandResult setup(ITseStatus iTseStatus, boolean bl) {
        CommandResult commandResult;
        WormStore wormStore = new WormStore(this.mountPoint);
        try {
            Object object = "";
            CommandResult commandResult2 = null;
            commandResult2 = bl ? this.factoryReset(iTseStatus, wormStore) : this.setupTask(iTseStatus, wormStore);
            if (commandResult2.isOk()) {
                logger.log2("Start InfoTask");
                object = (String)object + this.infoTask(wormStore).toString() + "\n";
                logger.log2("Completed InfoTask. Out=" + (String)object);
            } else {
                object = commandResult2.toString() + "\n";
            }
            commandResult = new CommandResult(true, (String)object);
        }
        catch (Throwable throwable) {
            try {
                try {
                    wormStore.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                throwable3.printStackTrace();
                return new CommandResult(false, "Exception: " + throwable3.getMessage());
            }
        }
        wormStore.close();
        return commandResult;
    }

    private CommandResult userunblock(ITseStatus iTseStatus) {
        CommandResult commandResult;
        WormStore wormStore = new WormStore(this.mountPoint);
        try {
            logger.log2("Start userunblock");
            wormStore.user_unblock(WormUserId.WORM_USER_ADMIN, this.puk, this.pin);
            logger.log2("Completed userunblock");
            commandResult = new CommandResult(true, "User unblocked");
        }
        catch (Throwable throwable) {
            try {
                try {
                    wormStore.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (WormAuthenticationFailedException wormAuthenticationFailedException) {
                return new CommandResult(false, "WormAuthenticationFailedException: " + wormAuthenticationFailedException.getMessage());
            }
            catch (Throwable throwable3) {
                throwable3.printStackTrace();
                return new CommandResult(false, "Exception: " + throwable3.getMessage());
            }
        }
        wormStore.close();
        return commandResult;
    }

    private CommandResult factoryReset(ITseStatus iTseStatus, WormStore wormStore) {
        Object object = "";
        wormStore.tse_factoryReset();
        try {
            logger.log0("Start Self Test");
            wormStore.tse_runSelfTest(this.clientid);
            logger.log0("Completed Self Test");
            object = (String)object + "Self Test completed. ";
        }
        catch (WormException wormException) {
            if (wormException.error() != WormError.WORM_ERROR_CLIENT_NOT_REGISTERED) {
                return new CommandResult(true, (String)object);
            }
            object = (String)object + "Eception: " + wormException.getMessage();
            return new CommandResult(false, (String)object);
        }
        return new CommandResult(true, (String)object);
    }

    private CommandResult setupTask(ITseStatus iTseStatus, WormStore wormStore) {
        Object object = "";
        WormInitializationState wormInitializationState = wormStore.info().initializationState();
        logger.log0("TSE init state = " + wormInitializationState.toString());
        object = (String)object + "Init state = " + wormInitializationState.toString() + ".";
        if (wormInitializationState != WormInitializationState.WORM_INIT_UNINITIALIZED) {
            logger.log0("TSE was already intialized - setup not done");
            object = (String)object + "TSE was already intialized - setup not done";
            return new CommandResult(false, (String)object);
        }
        try {
            logger.log0("Start a self test before doing the setup. An exception WORM_ERROR_CLIENT_NOT_REGISTERED is expected");
            wormStore.tse_runSelfTest(this.clientid);
        }
        catch (WormException wormException) {
            logger.log0("Self Test returned with this exception: " + wormException.getMessage());
        }
        logger.log0("Start Setup");
        wormStore.tse_setup("SwissbitSwissbit".getBytes(StandardCharsets.UTF_8), this.puk, this.pin, this.pin, this.clientid);
        logger.log0("Completed Setup");
        object = (String)object + "Setup completed. ";
        logger.log2("Start Login");
        wormStore.user_login(WormUserId.WORM_USER_ADMIN, this.pin);
        logger.log2("Logged in");
        long l = System.currentTimeMillis() / 1000L;
        wormStore.tse_updateTime(l);
        object = (String)object + "Time updated";
        if (!wormStore.info().hasValidTime()) {
            wormStore.tse_setup("SwissbitSwissbit".getBytes(StandardCharsets.UTF_8), this.puk, this.pin, this.pin, this.clientid);
        }
        wormStore.tse_registerClient(this.clientid);
        logger.log0("Client registered: " + this.clientid);
        return new CommandResult(true, (String)object);
    }

    private CommandResult infoTask(WormStore wormStore) {
        CommandResult commandResult;
        block18: {
            try {
                if (wormStore == null) {
                    wormStore = new WormStore(this.mountPoint);
                }
            }
            catch (Exception exception) {
                return new CommandResult(false, "WormStore cannot be opened: " + exception.getMessage());
            }
            WormInformation wormInformation = wormStore.info();
            try {
                long l = wormStore.info().remainingSignatures();
                String string = "Anzahl verbleibender Signaturen: " + l;
                if (l < 1L) {
                    string = string + " (TSE auswechseln!)";
                }
                long l2 = wormStore.info().certificateExpirationDate();
                long l3 = System.currentTimeMillis() / 1000L;
                String string2 = "";
                if (l2 <= l3) {
                    string2 = "Zertifikat ist abgelaufen! TSE auswechseln!\n";
                }
                String string3 = "TSE initialization state undefined";
                WormInitializationState wormInitializationState = wormStore.info().initializationState();
                if (wormInitializationState == WormInitializationState.WORM_INIT_DECOMMISSIONED) {
                    string3 = "TSE decommissioned";
                } else if (wormInitializationState == WormInitializationState.WORM_INIT_INITIALIZED) {
                    string3 = "TSE is initialized";
                } else if (wormInitializationState == WormInitializationState.WORM_INIT_UNINITIALIZED) {
                    string3 = "TSE is uninitialized";
                }
                byte[] byArray = wormStore.info().customizationIdentifier();
                String string4 = BaseTseCommand.bytesToHex(byArray);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
                String string5 = "TseDescription: " + wormInformation.tseDescription() + "\n";
                string5 = string5 + "Serial Number: " + TseAdminCommand.bytesToHex(wormInformation.tseSerialNumber()) + "\n";
                string5 = string5 + "Hardware Version: " + wormInformation.hardwareVersion() + "\n";
                string5 = string5 + "Size: " + wormInformation.size() + "\n";
                string5 = string5 + "Tar Export Size: " + wormInformation.tarExportSize() + "\n";
                string5 = string5 + "Public Key: " + TseAdminCommand.bytesToHex(wormInformation.tsePublicKey()) + "\n";
                string5 = string5 + "certificateExpirationDate: " + simpleDateFormat.format(wormInformation.certificateExpirationDate() * 1000L) + "\n";
                string5 = string5 + "Created Signatures: " + wormInformation.createdSignatures() + "\n";
                string5 = string5 + "hasValidTime: " + wormInformation.hasValidTime() + "\n";
                string5 = string5 + "Worm State: " + string3 + "\n";
                string5 = string5 + "IsCtssInterfaceActive = " + wormStore.info().isCtssInterfaceActive() + "\n";
                string5 = string5 + "HasChangedAdminPin = " + wormStore.info().hasChangedAdminPin() + "\n";
                string5 = string5 + "HadChangedTimeAdminPin = " + wormStore.info().hasChangedTimeAdminPin() + "\n";
                string5 = string5 + "HasChangedPUK = " + wormStore.info().hasChangedPuk() + "\n";
                string5 = string5 + "IsDeveloppmentFirmware = " + wormStore.info().isDevelopmentFirmware() + "\n";
                string5 = string5 + "Software version = " + wormStore.info().softwareVersion() + "\n";
                string5 = string5 + "Needs replacement = " + wormStore.flashHealthSummary().needsReplacement() + "\n";
                string5 = string5 + "CustomizationIdentifier = " + string4 + "\n";
                string5 = string5 + "Form Factor of TSE=" + wormStore.info().formFactor() + "\n";
                string5 = string5 + string + "\n";
                string5 = string5 + string2;
                commandResult = new CommandResult(true, string5);
                if (wormInformation == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (wormInformation != null) {
                        try {
                            wormInformation.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return new CommandResult(false, exception.getMessage());
                }
            }
            wormInformation.close();
        }
        return commandResult;
    }

    private CommandResult export_to_local_tmp(ITseStatus iTseStatus) {
        WormStore wormStore;
        if (iTseStatus.isBusy()) {
            return new CommandResult(false, "TSE is busy");
        }
        iTseStatus.setIsBusy(true);
        try {
            wormStore = new WormStore(this.mountPoint);
        }
        catch (Exception exception) {
            iTseStatus.setIsBusy(false);
            return new CommandResult(false, "WormStore cannot be opened: " + exception.getMessage());
        }
        final String string = iTseStatus.getTarExportFile();
        WormExportTarCallback wormExportTarCallback = new WormExportTarCallback(){

            public int onNewData(byte[] byArray) {
                try (FileOutputStream fileOutputStream = new FileOutputStream(string, true);){
                    fileOutputStream.write(byArray);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return -1;
                }
                return 0;
            }
        };
        wormStore.export_tar(wormExportTarCallback);
        wormStore.close();
        iTseStatus.setIsBusy(false);
        return new CommandResult(true, "Export completed");
    }

    private CommandResult exportdownload(HttpExchange httpExchange) {
        WormStore wormStore;
        logger.log2("TSE Tar Download requested");
        System.out.println("Start TSE Tar-Download");
        try {
            wormStore = new WormStore(this.mountPoint);
        }
        catch (Exception exception) {
            logger.log2("WormStore cannot be opened at mount point " + this.mountPoint);
            return new CommandResult(false, "WormStore cannot be opened: " + exception.getMessage());
        }
        httpExchange.getResponseHeaders().set("Content-Type", "application/x-tar ");
        httpExchange.getResponseHeaders().add("Content-Disposition", "filename=tse-export.tar");
        try {
            httpExchange.sendResponseHeaders(200, 0L);
            logger.log2("Header 200 sent");
            System.out.println("Tar-Download: Header 200 sent");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            logger.log2("Closing wormStore because of exception " + iOException.getMessage());
            wormStore.close();
            return new CommandResult(false, "Cannot send data: " + iOException.getMessage());
        }
        TseTarExportCallback tseTarExportCallback = new TseTarExportCallback(httpExchange.getResponseBody(), logger);
        logger.log2("Registering callback for export_tar...");
        wormStore.export_tar((WormExportTarCallback)tseTarExportCallback);
        logger.log2("Closing wormstore");
        wormStore.close();
        System.out.println("Tar-Download: Content sent");
        try {
            logger.log2("Closing reponse body...");
            httpExchange.getResponseBody().close();
            logger.log2("Reponse body closed");
        }
        catch (IOException iOException) {
            logger.log0("Response Body could not be closed: " + iOException.getMessage());
            iOException.printStackTrace();
            return new CommandResult(false, "Problem: " + iOException.getMessage());
        }
        httpExchange.close();
        System.out.println("Tar-Download: Closed HttpExchange");
        return new CommandResult(true, "Export completed");
    }

    private CommandResult exportdownloadlastyear(HttpExchange httpExchange, String string) {
        WormStore wormStore;
        logger.log2("TSE Tar Download requested for last year");
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zonedDateTime = ZonedDateTime.now(zoneId);
        ZonedDateTime zonedDateTime2 = zonedDateTime.minusMonths(12L);
        long l = zonedDateTime2.toInstant().getEpochSecond();
        long l2 = zonedDateTime.toInstant().getEpochSecond();
        l2 = -1L;
        System.out.println("Start TSE Tar-Download");
        try {
            wormStore = new WormStore(this.mountPoint);
        }
        catch (Exception exception) {
            logger.log2("WormStore cannot be opened at mount point " + this.mountPoint);
            return new CommandResult(false, "WormStore cannot be opened: " + exception.getMessage());
        }
        httpExchange.getResponseHeaders().set("Content-Type", "application/x-tar ");
        httpExchange.getResponseHeaders().add("Content-Disposition", "filename=tse-export-last-year.tar");
        try {
            httpExchange.sendResponseHeaders(200, 0L);
            logger.log2("Header 200 sent");
            System.out.println("Tar-Download: Header 200 sent");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            logger.log2("Closing wormStore because of exception " + iOException.getMessage());
            wormStore.close();
            return new CommandResult(false, "Cannot send data: " + iOException.getMessage());
        }
        TseTarExportCallback tseTarExportCallback = new TseTarExportCallback(httpExchange.getResponseBody(), logger);
        logger.log2("Registering callback for export_tar...");
        wormStore.export_tar_filtered_time(l, l2, string, (WormExportTarCallback)tseTarExportCallback);
        logger.log2("Closing wormstore");
        wormStore.close();
        System.out.println("Tar-Download: Content sent");
        try {
            logger.log2("Closing reponse body...");
            httpExchange.getResponseBody().close();
            logger.log2("Reponse body closed");
        }
        catch (IOException iOException) {
            logger.log0("Response Body could not be closed: " + iOException.getMessage());
            iOException.printStackTrace();
            return new CommandResult(false, "Problem: " + iOException.getMessage());
        }
        httpExchange.close();
        System.out.println("Tar-Download: Closed HttpExchange");
        return new CommandResult(true, "Export completed");
    }

    private static CommandResult getlog() {
        return new CommandResult(true, logger.output(false));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CommandResult check(ITseStatus iTseStatus) {
        if (iTseStatus.isBusy()) {
            return new CommandResult(false, "TSE is busy");
        }
        if (!iTseStatus.isCheckUseful()) {
            logger.log2("Ignore Check request - last check not that far in the past");
            return new CommandResult(true, "OK");
        }
        iTseStatus.setIsBusy(true);
        iTseStatus.setLastCheckResult(false);
        logger.log2("Check for TSE Status and availability");
        try (WormStore wormStore = new WormStore(this.mountPoint);){
            long l;
            long l2;
            long l3;
            if (!wormStore.info().hasPassedSelfTest()) {
                logger.log0("TSE has no valid self test due to info from WormInformation instance. Start self test now.");
                CommandResult commandResult = TseCmdExecutor.selftest(iTseStatus, true, this.mountPoint, this.clientid, logger, this.pin);
                if (!commandResult.isOk()) {
                    iTseStatus.setIsBusy(false);
                    CommandResult commandResult2 = commandResult;
                    return commandResult2;
                }
            }
            if ((l3 = wormStore.info().timeUntilNextSelfTest()) < 14400L) {
                logger.log0("TSE has no valid self test because next self test is in less than 4 hours. Start self test now.");
                CommandResult commandResult = TseCmdExecutor.selftest(iTseStatus, true, this.mountPoint, this.clientid, logger, this.pin);
                if (!commandResult.isOk()) {
                    iTseStatus.setIsBusy(false);
                    CommandResult commandResult3 = commandResult;
                    return commandResult3;
                }
            }
            if ((l2 = wormStore.info().remainingSignatures()) < 1L) {
                logger.log0("No more available TSE signatures");
                iTseStatus.setIsBusy(false);
                CommandResult commandResult = new CommandResult(false, "No more available TSE signatures!");
                return commandResult;
            }
            long l4 = wormStore.info().certificateExpirationDate();
            if (l4 <= (l = System.currentTimeMillis() / 1000L)) {
                logger.log0("Certificate of TSE has expired");
                iTseStatus.setIsBusy(false);
                CommandResult commandResult = new CommandResult(false, "Certificate of TSE has expired!");
                return commandResult;
            }
            if (wormStore.info().initializationState() != WormInitializationState.WORM_INIT_INITIALIZED) {
                CommandResult commandResult = new CommandResult(false, "WormStore not initialized - do not try to log in. Stopping check.");
                return commandResult;
            }
            wormStore.user_login(WormUserId.WORM_USER_ADMIN, this.pin);
            wormStore.tse_registerClient(this.clientid);
            boolean bl = this.doTimeCheckAndUpdate(iTseStatus);
            iTseStatus.setIsBusy(false);
            if (bl) {
                iTseStatus.setLastCheckResult(true);
                iTseStatus.setSuccessfulCheckIsDone();
                CommandResult commandResult = new CommandResult(true, "OK");
                return commandResult;
            }
            iTseStatus.setLastCheckResult(false);
            CommandResult commandResult = new CommandResult(false, "Time check not successful");
            return commandResult;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            iTseStatus.setIsBusy(false);
            return new CommandResult(false, "Exception: " + throwable.getMessage());
        }
    }

    private boolean doTimeCheckAndUpdate(ITseStatus iTseStatus) {
        Object object;
        CommandResult commandResult;
        long l = System.currentTimeMillis() / 1000L;
        boolean bl = false;
        try (WormStore wormStore = new WormStore(this.mountPoint);){
            boolean bl2 = wormStore.info().hasValidTime();
            if (!bl2) {
                logger.log2("TSE has no valid time. Set time now.");
                bl = true;
            }
        }
        catch (Exception exception) {
            logger.log0("TSE info about time status could not be retrieved: " + exception.getMessage());
        }
        if (!iTseStatus.isTseTimeSet()) {
            logger.log2("TSE needs time sync because soon expiration of maxSyncTime after last time sync");
            bl = true;
        }
        boolean bl3 = false;
        if (bl) {
            try (WormStore wormStore = new WormStore(this.mountPoint);){
                wormStore.tse_updateTime(l);
                iTseStatus.setTseTimeSet(true);
                logger.log2("TSE time is set");
            }
            catch (Exception exception) {
                bl3 = true;
                logger.log0("TSE update time resulted into an error so self test will be triggered. Error message: " + exception.getMessage());
            }
        }
        if (bl3 && !(commandResult = TseCmdExecutor.selftest(iTseStatus, true, this.mountPoint, this.clientid, logger, this.pin)).isOk()) {
            logger.log0("TSE self test went wrong");
            return false;
        }
        bl3 = false;
        try {
            object = new WormStore(this.mountPoint);
            try {
                l = System.currentTimeMillis() / 1000L;
                object.tse_updateTime(l);
                iTseStatus.setTseTimeSet(true);
                logger.log2("TSE time is set");
                bl3 = !object.info().hasPassedSelfTest();
            }
            finally {
                object.close();
            }
        }
        catch (Exception exception) {
            logger.log0("TSE update time resulted into an error: " + exception.getMessage());
            return false;
        }
        if (bl3 && !((CommandResult)(object = TseCmdExecutor.selftest(iTseStatus, true, this.mountPoint, this.clientid, logger, this.pin))).isOk()) {
            logger.log0("TSE self test went wrong");
            return false;
        }
        return true;
    }
}

