/*
 * Decompiled with CFR 0.152.
 */
package tseconnector.commands;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.secureflashcard.wormapi.WormEntry;
import com.secureflashcard.wormapi.WormError;
import com.secureflashcard.wormapi.WormException;
import com.secureflashcard.wormapi.WormStore;
import com.secureflashcard.wormapi.WormTransactionResponse;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.json.simple.JSONObject;
import tseconnector.ITseStatus;
import tseconnector.commands.BaseTseCommand;
import tseconnector.commands.CommandResult;
import tseconnector.commands.TseCmdExecutor;

public class TseSignCommand
extends BaseTseCommand {
    public String value;
    @JsonIgnore
    public static String correctPass = "";

    @Override
    public CommandResult doCmd(ITseStatus iTseStatus) {
        if (this.cmd.compareTo("signorders") == 0) {
            return this.signvalue(iTseStatus, "Bestellung-V1");
        }
        if (this.cmd.compareTo("signnormalbill") == 0) {
            return this.signvalue(iTseStatus, "Kassenbeleg-V1");
        }
        if (this.cmd.compareTo("signfreecontent") == 0) {
            return this.signvalue(iTseStatus, "SonstigerVorgang");
        }
        return new CommandResult(false, "No valid command sent: " + this.cmd);
    }

    private CommandResult signvalue(ITseStatus iTseStatus, String string) {
        CommandResult commandResult;
        CommandResult commandResult2 = this.makeTseReady(iTseStatus);
        if (!commandResult2.isOk()) {
            return new CommandResult(false, "TSE not ready");
        }
        boolean bl = this.waitForTseReady(iTseStatus);
        if (!bl) {
            return new CommandResult(false, "TSE not ready");
        }
        logger.log1("Starte Signierung");
        WormTransactionResponse wormTransactionResponse = null;
        WormStore wormStore = new WormStore(this.mountPoint);
        try {
            String string2 = WormStore.signatureAlgorithm();
            TseCmdExecutor.completeUnfinishedTransactions(wormStore, this.clientid, logger, 0);
            wormTransactionResponse = wormStore.transaction_start(this.clientid, new byte[0], "");
            wormTransactionResponse = wormStore.transaction_finish(this.clientid, wormTransactionResponse.transactionNumber(), this.value.getBytes(StandardCharsets.UTF_8), string);
            WormEntry wormEntry = wormStore.lastEntry();
            long l = wormTransactionResponse.logTime();
            long l2 = wormTransactionResponse.signatureCounter();
            long l3 = wormTransactionResponse.transactionNumber();
            byte[] byArray = wormTransactionResponse.signature();
            String string3 = Base64.getEncoder().encodeToString(byArray);
            byte[] byArray2 = wormTransactionResponse.serialNumber();
            String string4 = Base64.getEncoder().encodeToString(byArray2);
            byte[] byArray3 = wormStore.info().tsePublicKey();
            String string5 = Base64.getEncoder().encodeToString(byArray3);
            String string6 = Base64.getEncoder().encodeToString(wormStore.getLogMessageCertificate());
            long l4 = wormStore.info().timeUntilNextTimeSynchronization();
            if (l4 != 0L && l4 < 300L) {
                iTseStatus.setTseTimeSet(false);
            }
            logger.log1("  Last Transaction Details");
            logger.log1("  Log Time: " + l);
            logger.log1("  Signature Counter: " + l2);
            logger.log1("  Transaction Number: " + l3);
            logger.log1("  Log Message Length: " + wormEntry.logMessageLength());
            logger.log1("  Process Data Length: " + wormEntry.processDataLength());
            logger.log1("  Log Message:\n" + TseSignCommand.bytesToHex(wormEntry.readLogMessage()));
            logger.log1("  SigAlg: " + string2);
            logger.log1("  Signature: " + string3);
            logger.log1("  TSESerialNo: " + string4);
            logger.log1("  TSEPublicKey: " + string5);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"logtime", (Object)l);
            jSONObject.put((Object)"trans", (Object)l3);
            jSONObject.put((Object)"sigcounter", (Object)l2);
            jSONObject.put((Object)"sigalg", (Object)string2);
            jSONObject.put((Object)"signature", (Object)string3);
            jSONObject.put((Object)"publickey", (Object)string5);
            jSONObject.put((Object)"serialno", (Object)TseSignCommand.bytesToHex(byArray2));
            jSONObject.put((Object)"certificate", (Object)string6);
            commandResult = new CommandResult(true, jSONObject);
        }
        catch (Throwable throwable) {
            try {
                try {
                    wormStore.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (WormException wormException) {
                if (wormException.error().equals((Object)WormError.WORM_ERROR_NO_TIME_SET)) {
                    iTseStatus.setTseTimeSet(false);
                    return new CommandResult(false, "No signing possible: Exception because time was not set.");
                }
                wormException.printStackTrace();
                return new CommandResult(false, "No signing possible: Exception: " + wormException.getMessage());
            }
            catch (Throwable throwable3) {
                throwable3.printStackTrace();
                return new CommandResult(false, "No signing possible: Exception: " + throwable3.getMessage());
            }
        }
        wormStore.close();
        return commandResult;
    }
}

