/*
 * Decompiled with CFR 0.152.
 */
package tseconnector.commands.sim;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.secureflashcard.wormapi.WormError;
import com.secureflashcard.wormapi.WormException;
import com.secureflashcard.wormapi.WormInitializationState;
import com.sun.net.httpserver.HttpExchange;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import tseconnector.ITseStatus;
import tseconnector.commands.BaseTseCommand;
import tseconnector.commands.CommandResult;

public class TseAdminCommandSimulation
extends BaseTseCommand {
    public byte[] puk;
    @JsonIgnore
    public static String correctPass = "";
    @JsonIgnore
    private final String credseed = "SwissbitSwissbit";

    public String toString() {
        return "Tsecmd [pass=" + this.pass + ", pin=" + Arrays.toString(this.pin) + ", puk=" + Arrays.toString(this.puk) + ", cmd=" + this.cmd + "]";
    }

    @Override
    public CommandResult doCmd(ITseStatus iTseStatus) {
        if (this.cmd.compareTo("factory_reset") == 0) {
            return this.setup(true);
        }
        if (this.cmd.compareTo("setup") == 0) {
            return this.setup(false);
        }
        if (this.cmd.compareTo("getinfo") == 0) {
            return this.infoTask();
        }
        if (this.cmd.compareTo("decom") == 0) {
            return this.decom();
        }
        if (this.cmd.compareTo("exportdownload") == 0) {
            return this.exportdownload(this.t);
        }
        if (this.cmd.compareTo("exportdownloadlastyear") == 0) {
            return this.exportdownloadlastyear(this.t, "");
        }
        if (this.cmd.compareTo("exportlocal") == 0) {
            return this.export_to_local_tmp(iTseStatus);
        }
        if (this.cmd.compareTo("exportdemodownload") == 0) {
            return this.exportdownload(this.t);
        }
        if (this.cmd.compareTo("forceselftest") == 0) {
            return this.selftest(iTseStatus, true);
        }
        if (this.cmd.compareTo("selftest") == 0) {
            return this.selftest(iTseStatus, false);
        }
        if (this.cmd.compareTo("getlog") == 0) {
            return TseAdminCommandSimulation.getlog();
        }
        if (this.cmd.compareTo("check") == 0) {
            return TseAdminCommandSimulation.check(iTseStatus);
        }
        if (this.cmd.compareTo("userunblock") == 0) {
            return this.userunblock(iTseStatus);
        }
        return new CommandResult(false, "No valid command sent: " + this.cmd);
    }

    private CommandResult selftest(ITseStatus iTseStatus, boolean bl) {
        logger.log0("Start Self Test");
        logger.log0("Completed Self Test");
        return new CommandResult(true, "Self Test completed");
    }

    public CommandResult decom() {
        logger.log0("Start Decom");
        logger.log0("Completed Decom");
        return new CommandResult(true, "Decommission completed");
    }

    private CommandResult userunblock(ITseStatus iTseStatus) {
        logger.log2("Simulate start userunblock");
        logger.log2("Simulate completed userunblock");
        return new CommandResult(true, "User unblocked");
    }

    public CommandResult setup(boolean bl) {
        String string = String.valueOf(this.setupTask(bl)) + "\n";
        logger.log2("Start InfoTask");
        string = string + "Info...\n";
        logger.log2("Completed InfoTask. Out=" + string);
        return new CommandResult(true, string);
    }

    private CommandResult setupTask(boolean bl) {
        Object object = "";
        object = bl ? (String)object + "Factory Reset done. " : (String)object + "No factory reset done. ";
        try {
            logger.log0("Start Self Test");
            logger.log0("Completed Self Test");
            object = (String)object + "Self Test completed. ";
        }
        catch (WormException wormException) {
            if (wormException.error() != WormError.WORM_ERROR_CLIENT_NOT_REGISTERED) {
                throw wormException;
            }
            WormInitializationState wormInitializationState = WormInitializationState.WORM_INIT_UNINITIALIZED;
            object = (String)object + "Init state = " + wormInitializationState.toString() + ".";
            if (wormInitializationState == WormInitializationState.WORM_INIT_UNINITIALIZED) {
                logger.log0("Start Setup");
                logger.log0("Completed Setup");
                object = (String)object + "Setup completed. ";
            }
            logger.log2("TSE was already intialized - setup not done");
            object = (String)object + "TSE was already intialized - setup not done";
            return new CommandResult(true, (String)object);
        }
        System.out.println("Start Login");
        System.out.println("Logged in");
        object = (String)object + "Time updated";
        return new CommandResult(true, (String)object);
    }

    private CommandResult infoTask() {
        long l = 3L;
        String string = "Anzahl verbleibender Signaturen: " + l;
        if (l < 1L) {
            string = string + " (TSE auswechseln!)";
        }
        long l2 = System.currentTimeMillis() / 1000L;
        long l3 = l2 + 20L;
        String string2 = "";
        if (l3 <= l2) {
            string2 = "Zertifikat ist abgelaufen! TSE auswechseln!\n";
        }
        Object object = "\n\nHINWEIS:\nDas sind nur statische Demo-Werte. Sie stammen nicht von einer echten TSE!!!\n\n";
        object = (String)object + "TseDescription: BSI-K-TR-0362\n";
        object = (String)object + "Serial Number: 7F5B69CC5E41C803F17242DAC2B3664D33FC2C1039FE892AB0B1D81FF695A7BA\n";
        object = (String)object + "Hardware Version: 65538\n";
        object = (String)object + "Size: 24\n";
        object = (String)object + "Tar Export Size: 13312\n";
        object = (String)object + "Public Key: 0456BBD8B2C11063B9C9C16B68EB9B3F8F7502E1279DA8A4909AADF4270220C573CB175B47E3BB7F541806CA17E33BAECF23823E12AFA210B09BA3AB26E8DE8A665054BA94B188FA29287F4B4EDBAB167A77FE67A442849B1F69351CB46F5A903A\n";
        object = (String)object + "certificateExpirationDate: 2026-05-29 01:59:59\n";
        object = (String)object + "Created Signatures: 892\n";
        object = (String)object + "hasValidTime: true";
        object = (String)object + "Worm State: TSE is initialized\n";
        object = (String)object + "IsCtssInterfaceActive = true\n";
        object = (String)object + "HasChangedAdminPin = true\n";
        object = (String)object + "HadChangedTimeAdminPin = true\n";
        object = (String)object + "HasChangedPUK = true\n";
        object = (String)object + "IsDeveloppmentFirmware = false\n";
        object = (String)object + "Software version = 65538\n";
        object = (String)object + "Needs replacement = false\n";
        object = (String)object + "CustomizationIdentifier = 474D4953\n";
        object = (String)object + "Form Factor of TSE=SD\n";
        object = (String)object + string + "\n";
        object = (String)object + string2;
        return new CommandResult(true, (String)object);
    }

    private CommandResult export_to_local_tmp(ITseStatus iTseStatus) {
        if (iTseStatus.isBusy()) {
            return new CommandResult(false, "TSE is busy");
        }
        iTseStatus.setIsBusy(true);
        String string = iTseStatus.getTarExportFile();
        try (FileInputStream fileInputStream = new FileInputStream("src/tseconnector/commands/sim/tse-export-sample.tar");
             FileOutputStream fileOutputStream = new FileOutputStream(string, true);){
            int n;
            while ((n = ((InputStream)fileInputStream).read()) != -1) {
                fileOutputStream.write(n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return new CommandResult(false, "Export failed: " + iOException.getMessage());
        }
        iTseStatus.setIsBusy(false);
        return new CommandResult(true, "Export completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandResult exportdownload(HttpExchange httpExchange) {
        System.out.println("Start Demo TSE Tar-Download");
        httpExchange.getResponseHeaders().set("Content-Type", "application/x-tar ");
        httpExchange.getResponseHeaders().add("Content-Disposition", "filename=tse-export.tar");
        try {
            httpExchange.sendResponseHeaders(200, 0L);
            System.out.println("Tar-Download: Header 200 sent");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return new CommandResult(false, "Cannot send data: " + iOException.getMessage());
        }
        FileInputStream fileInputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream("src/tseconnector/commands/sim/tse-export-sample.tar");
            while ((n = ((InputStream)fileInputStream).read()) != -1) {
                try {
                    httpExchange.getResponseBody().write(n);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    CommandResult commandResult = new CommandResult(false, "Cannot send data: " + iOException.getMessage());
                    try {
                        ((InputStream)fileInputStream).close();
                        System.out.println("Tar-Download: Closed demo input stream");
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                        return new CommandResult(false, "Error closing sample input file: " + iOException2.getMessage());
                    }
                    return commandResult;
                }
            }
            System.out.println("Tar-Download: Content sent");
            httpExchange.getResponseBody().close();
            System.out.println("Tar-Download: Closing response body stream");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            CommandResult commandResult = new CommandResult(false, "Problem: " + exception.getMessage());
            return commandResult;
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
                System.out.println("Tar-Download: Closed demo input stream");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return new CommandResult(false, "Error closing sample input file: " + iOException.getMessage());
            }
        }
        httpExchange.close();
        System.out.println("Tar-Download: Closed HttpExchange");
        return new CommandResult(true, "Export completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandResult exportdownloadlastyear(HttpExchange httpExchange, String string) {
        System.out.println("Start Demo TSE Tar-Download");
        httpExchange.getResponseHeaders().set("Content-Type", "application/x-tar ");
        httpExchange.getResponseHeaders().add("Content-Disposition", "filename=tse-export.tar");
        try {
            httpExchange.sendResponseHeaders(200, 0L);
            System.out.println("Tar-Download: Header 200 sent");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return new CommandResult(false, "Cannot send data: " + iOException.getMessage());
        }
        FileInputStream fileInputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream("src/tseconnector/commands/sim/tse-export-sample.tar");
            while ((n = ((InputStream)fileInputStream).read()) != -1) {
                try {
                    httpExchange.getResponseBody().write(n);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    CommandResult commandResult = new CommandResult(false, "Cannot send data: " + iOException.getMessage());
                    try {
                        ((InputStream)fileInputStream).close();
                        System.out.println("Tar-Download: Closed demo input stream");
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                        return new CommandResult(false, "Error closing sample input file: " + iOException2.getMessage());
                    }
                    return commandResult;
                }
            }
            System.out.println("Tar-Download: Content sent");
            httpExchange.getResponseBody().close();
            System.out.println("Tar-Download: Closing response body stream");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            CommandResult commandResult = new CommandResult(false, "Problem: " + exception.getMessage());
            return commandResult;
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
                System.out.println("Tar-Download: Closed demo input stream");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return new CommandResult(false, "Error closing sample input file: " + iOException.getMessage());
            }
        }
        httpExchange.close();
        System.out.println("Tar-Download: Closed HttpExchange");
        return new CommandResult(true, "Export completed");
    }

    private static CommandResult getlog() {
        return new CommandResult(true, logger.output(false));
    }

    private static CommandResult check(ITseStatus iTseStatus) {
        if (!iTseStatus.isCheckUseful()) {
            return new CommandResult(true, "OK");
        }
        if (iTseStatus.isBusy()) {
            return new CommandResult(false, "TSE is busy");
        }
        iTseStatus.setIsBusy(true);
        logger.log2("Check for TSE Status and availability");
        logger.log0("Simuliere Self Test");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        logger.log0("Beende Simulation Self Test");
        iTseStatus.setTseTimeSet(true);
        iTseStatus.setIsBusy(false);
        iTseStatus.setLastCheckResult(true);
        iTseStatus.setSuccessfulCheckIsDone();
        return new CommandResult(true, "OK");
    }
}

