/*
 * Decompiled with CFR 0.152.
 */
package tseconnector.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Base64;
import tseconnector.ITseStatus;
import tseconnector.TseConnectorLog;
import tseconnector.commands.CommandResult;
import tseconnector.commands.ITseCommand;
import tseconnector.commands.TseAdminCommand;
import tseconnector.commands.TseSignCommand;
import tseconnector.commands.sim.TseAdminCommandSimulation;
import tseconnector.commands.sim.TseSignCommandSimulation;
import tseconnector.tseconnector;

public class RequestHandler
implements HttpHandler {
    protected ITseStatus tseStatus = null;
    protected TseConnectorLog logger = null;
    private String correctPass = "";
    private String mountPoint;
    private String mode;

    private RequestHandler() {
    }

    public RequestHandler(String string, ITseStatus iTseStatus, String string2, TseConnectorLog tseConnectorLog, String string3) {
        this.correctPass = string;
        this.tseStatus = iTseStatus;
        this.logger = tseConnectorLog;
        this.mountPoint = string2;
        this.mode = string3;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        try {
            String string = "";
            String string2 = this.postDataFromRequest(httpExchange);
            ITseCommand iTseCommand = this.parseInput(string2, this.mode, httpExchange);
            if (iTseCommand.getPass().compareTo(this.correctPass) != 0) {
                CommandResult commandResult = new CommandResult(false, "Falsches Passwort");
                string = commandResult.resultToTransmit();
            } else {
                iTseCommand.setMountPoint(this.mountPoint);
                CommandResult commandResult = iTseCommand.doCmd(this.tseStatus);
                string = commandResult.resultToTransmit();
            }
            if (iTseCommand.getCmd().compareTo("exportdownload") != 0 && iTseCommand.getCmd().compareTo("exportdownloadlastyear") != 0) {
                this.sendToClient(httpExchange, string);
            }
        }
        catch (Exception exception) {
            this.logger.log0("Handle Request fehlgeschlagen: " + exception.getMessage());
            exception.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            try {
                CommandResult commandResult = new CommandResult(false, stringWriter.toString());
                this.sendToClient(httpExchange, commandResult.resultToTransmit());
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
    }

    protected String postDataFromRequest(HttpExchange httpExchange) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        InputStream inputStream = httpExchange.getRequestBody();
        while ((n = inputStream.read()) != -1) {
            stringBuilder.append((char)n);
        }
        String string = stringBuilder.toString();
        String[] stringArray = string.split("=", 2);
        String string2 = stringArray[1];
        string2 = string2.replaceAll("%3D", "=");
        byte[] byArray = Base64.getDecoder().decode(string2);
        String string3 = new String(byArray);
        this.logger.log2("Transferred POST-Data: " + string3);
        return string3;
    }

    protected void sendToClient(HttpExchange httpExchange, String string) throws Exception {
        httpExchange.sendResponseHeaders(200, string.length());
        OutputStream outputStream = httpExchange.getResponseBody();
        outputStream.write(string.getBytes());
        outputStream.close();
    }

    protected ITseCommand parseInput(String string, String string2, HttpExchange httpExchange) {
        ITseCommand iTseCommand = null;
        ObjectMapper objectMapper = null;
        try {
            objectMapper = new ObjectMapper();
        }
        catch (Exception exception) {
            System.err.println("Object Mapper could not be instantiated!");
            exception.printStackTrace();
        }
        try {
            if (string2.compareTo("admin") == 0) {
                iTseCommand = this.tseStatus.getMode() == tseconnector.Mode.Normal ? (ITseCommand)objectMapper.readValue(string, TseAdminCommand.class) : (ITseCommand)objectMapper.readValue(string, TseAdminCommandSimulation.class);
                iTseCommand.setHttpExchange(httpExchange);
            } else {
                iTseCommand = this.tseStatus.getMode() == tseconnector.Mode.Normal ? (ITseCommand)objectMapper.readValue(string, TseSignCommand.class) : (ITseCommand)objectMapper.readValue(string, TseSignCommandSimulation.class);
            }
            iTseCommand.setLogger(this.logger);
        }
        catch (IOException iOException) {
            System.err.println("Impossible to parse httpRequest:");
            iOException.printStackTrace();
        }
        return iTseCommand;
    }
}

