<?php

require_once 'php/dbutils.php';
require_once 'php/config.php';
defined('DB') || define ( 'DB','mysql' );

class Installer {
	
	private static function dropTable($pdo,$tablename) {
		try {
			$sql = "DROP TABLE $tablename";
			DbUtils::execSql($pdo, $sql, null);
		} catch (Exception $e) {
			// nothing - table not present or whatever...
		}
	}
	
	private static function createSystemTable($pdo)
	{
		self::dropTable($pdo, "%ossystem%");
		self::dropTable($pdo, "%gueststatus%");
		self::dropTable($pdo, "%queue%");
		self::dropTable($pdo, "%images%");

		$sql = "
		CREATE TABLE `%images%` (
		`id` INT (2) NOT NULL AUTO_INCREMENT PRIMARY KEY ,
		`imagename` VARCHAR ( 100 ) ,
		`content` MEDIUMBLOB,
		`contenttype` INT(1) NULL,
		`productid` INT(10) NULL
		) CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDb ;
		";
		DbUtils::execSql($pdo, $sql, null);

		$sql = "
		CREATE TABLE `%ossystem%` (
		id INT (10) NOT NULL AUTO_INCREMENT PRIMARY KEY ,
		item VARCHAR(20) NOT NULL,
		value MEDIUMTEXT NULL
		) CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDb ;
		";
		DbUtils::execSql($pdo, $sql, null);

		$sql = "INSERT INTO %ossystem% (item,value) VALUES(?,?)";
		DbUtils::execSql($pdo, $sql, array('resttables',''));
		DbUtils::execSql($pdo, $sql, array('timezone',''));
		DbUtils::execSql($pdo, $sql, array('dailycode',''));
		DbUtils::execSql($pdo, $sql, array('types',''));
		DbUtils::execSql($pdo, $sql, array('products',''));
		DbUtils::execSql($pdo, $sql, array('currency',''));
		DbUtils::execSql($pdo, $sql, array('theme',''));
		DbUtils::execSql($pdo, $sql, array('decpoint',''));
		
		$sql = "
		CREATE TABLE `%gueststatus%` (
		id INT (10) NOT NULL AUTO_INCREMENT PRIMARY KEY ,
		item VARCHAR(20) NOT NULL,
		date VARCHAR(100) NULL
		) CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDb ;
		";
		DbUtils::execSql($pdo, $sql, null);
		
		$sql = "INSERT INTO %gueststatus% (item,date) VALUES(?,?)";
		DbUtils::execSql($pdo, $sql, array('lastosaccess',null));
		
		$sql = "
		CREATE TABLE `%queue%` (
		id INT (10) NOT NULL AUTO_INCREMENT PRIMARY KEY ,
		date DATETIME NULL,
		tableid VARCHAR(10) NOT NULL,
		prodid VARCHAR(20) NOT NULL,
		tablecode VARCHAR(100) NOT NULL,
		dailycode VARCHAR(100) NOT NULL
		) CHARACTER SET utf8 COLLATE utf8_general_ci ENGINE = InnoDb ;
		";
		DbUtils::execSql($pdo, $sql, null);
	}
	
	public static function install($code) {
		$fileMsg = 'In der Konfiguration wurde festgelegt, dass die temporären Laufzeitdaten im Filesystem abgelegt werden sollen. ';
		$fileMsg .= 'Daher ist keine Installation erforderlich und das Gastbestellsystem kann direkt aufgerufen werden.<br><br>';
		$fileMsg .= '<form action="index.php" method="get"> <button type="submit">Weiter zur Gastbestellseite</button></form>';
		if (DB == 'file')  {
			return array("status" => "ERROR", "msg" => $fileMsg);
		};
		if ($code != CODE) {
			return array("status" => "ERROR", "msg" => "Falscher Installationscode!");
		}
		try {
			if (DB == 'mysql') {
				if (!extension_loaded("pdo_mysql")) {
					return array("status" => "ERROR", "msg" => "PHP Pdo-MySQL extension nicht geladen");
				}
				$pdo = DbUtils::openDbAndReturnPdoStatic();
				self::createSystemTable($pdo);
				return array("status" => "OK");
			}
		} catch (Exception $ex) {
			return array("status" => "ERROR", "msg" => $ex->getMessage());
		}
	}
}

if (isset($_POST['code'])) {
	$code = $_POST['code'];
	$status = Installer::install($code);
	
	if ($status["status"] != "OK") {
		echo("Ein Fehler ist aufgetreten: " . $status["msg"]);
	} else {
		echo("Installation war erfolgreich! Bitte install.php l&ouml;schen!!! Anschließend kamn die Applikation ohne den Zusatz 'install.php' aufgerufen werden.");
	}
	
} else {
	echo "<html>";
	echo "<head><title>Installation Gastsystem</title>";
	echo '<link rel="stylesheet" type="text/css" href="css/gueststyle.css?v=2.9.12">';
	echo "</head>";
	echo "<body><div class=surround>";
	echo "<span class=headerline>Installation OrderSprinter-Gastsystem 2.9.12</span><br><br>";
	echo "<form action='install.php' method='post'><input class=installfield name=code id=code type=text placeholder='Installationscode' />";
	echo "<br><input type=submit value='Installation starten' class=installbtn />";
	echo "</form></div></html>";
}