<?php
// Datenbank-Verbindungsparameter
require_once ('config.php');
defined('DB') || define ( 'DB','mysql' );
defined('LOG') || define ('LOG', false);
defined('MAX_LOG_CHARS') || define ('MAX_LOG_CHARS', 10000);

class DbUtils {
	public static $TYPE_LOGO = 1;
	public static $TYPE_PRODIMG = 2;
	private static $cachedTimezone = "Europe/Berlin";
	
	public static function openDbAndReturnPdoStatic() {
		$dsn = 'mysql:host=' . MYSQL_HOST . ';dbname=' . MYSQL_DB;
		$user = MYSQL_USER;
		$password = MYSQL_PASSWORD;
		$pdo = null;
		try {
			$pdo = new PDO($dsn, $user, $password);
			$pdo ->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		}
		catch (PDOException $e) {
			echo 'Connection failed: ' . $e->getMessage();
		}
		return $pdo;
	}

	
	public static function substTableAlias($sqlString) {
		$out = str_replace("%ossystem%",TAB_PREFIX . 'ossystem',$sqlString);
		$out = str_replace("%gueststatus%", TAB_PREFIX . 'gueststatus',$out);
		$out = str_replace("%queue%", TAB_PREFIX . 'queue',$out);
		$out = str_replace("%images%", TAB_PREFIX . 'images',$out);
		return $out;	
	}
	
	public static function getRowSqlObject($pdo,$sql,$params) {
		$stmt = $pdo->prepare(DbUtils::substTableAlias($sql));
		if (is_null($params)) {
			$stmt->execute();
		} else {
			$stmt->execute($params);
		}
		return ($stmt->fetchObject());
	}
	public static function fetchSqlAll($pdo,$sql,$params) {
		$stmt = $pdo->prepare(DbUtils::substTableAlias($sql));
		if (is_null($params)) {
			$stmt->execute();
		} else {
			$stmt->execute($params);
		}
		return ($stmt->fetchAll(PDO::FETCH_ASSOC));
	}
	
	public static function execSql($pdo,$sql,$params) {
		$stmt = $pdo->prepare(DbUtils::substTableAlias($sql));
		if (is_null($params)) {
			$stmt->execute();
		} else {
			$stmt->execute($params);
		}
		
	}
	
        public static function createColInMySqlTableIfNotExists($pdo,$table,$colname) {
                $tablePrefixed = TAB_PREFIX . $table;
                $sql = "SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA='" . MYSQL_DB . "' AND TABLE_NAME='$tablePrefixed' AND COLUMN_NAME=?";
                $res = self::fetchSqlAll($pdo, $sql, array($colname));
                if (count($res) == 0) {
                        // col does not exist
                        $sql = "ALTER TABLE $tablePrefixed ADD $colname varchar(500)";
                        self::execSql($pdo, $sql, null);
                }
        }
	private static function getOsValueFromDbFile($item,$default) {
		$filename = dirname(__FILE__) . '/../db/' . OSSYSTEM_FILE;
		try {
			if (file_exists($filename)) {
				$allData = file_get_contents($filename);
				$dataItems = json_decode($allData,true);
				if (isset($dataItems[$item])) {
					return $dataItems[$item];
				} else {
					return $default;
				}
			} else {
				return $default;
			}
		} catch (Exception $ex) {
			return $default;
		}
	}
	
	public static function getConfigItem($pdo,$item,$default) {
		$val = $default;
		if (DB == "mysql") {
			$sql = "select value from %ossystem% where item=?";
			$result = DbUtils::fetchSqlAll($pdo, $sql, array($item));
			if (count($result) > 0) {
				$val = $result[0]["value"];
			}
		} else {
			$val = self::getOsValueFromDbFile($item, $default);
		}
		if ($item == "timezone") {
			self::$cachedTimezone = $val;
		}
		return $val;
	}
	
	public static function getImageData($pdo,$imageName,$productid) {
		if (DB == "mysql") {
			if (is_null($productid)) {
				$sql = "SELECT content FROM %images% WHERE imagename=?";
				$result = DbUtils::fetchSqlAll($pdo, $sql, array($imageName));
			} else {
				$sql = "SELECT content FROM %images% WHERE productid=?";
				$result = DbUtils::fetchSqlAll($pdo, $sql, array($productid));
			}
			if (count($result) > 0) {
				return ($result[0]["content"]);
			} else {
				return null;
			}
		} else {
			$filename = dirname(__FILE__) . '/../db/' . IMAGES_FILE;
			try {
				if (file_exists($filename)) {
				
					$fileContent = file_get_contents($filename);
					$images = json_decode($fileContent,true);
				
					foreach($images as $img) {
						if (is_null($productid)) {
							if ($img["imagename"] == $imageName) {
								return $img["content"];
							}
						} else {
							if ($img["productid"] == $productid) {
								return $img["content"];
							}
						}
					}
				
				} 
			} catch (Exception $ex) { 
				return null;
			}
			return null;
		}
	}
	
	private static function logTruncated($filename, $max) {
		try {
			$offset = filesize($filename) - $max;
			if ($offset > 0) {
				$logsToKeep = file_get_contents($filename, NULL, NULL, $offset, $max);
				file_put_contents($filename, $logsToKeep);
			}
		} catch (Exception $ex) {}
	}

	public static function log($str) {
		if (LOG) {
			try {
				date_default_timezone_set(self::$cachedTimezone);
				$logfile = dirname(__FILE__) . '/../db/log.txt';
				self::logTruncated($logfile, MAX_LOG_CHARS);
				$logtime = date('Y-m-d H:i:s');
				file_put_contents($logfile, "$logtime: $str\r\n", FILE_APPEND);
			} catch (Exception $ex) { }
		}
	}
	
	public static function logVar($description,$v) {
		ob_start();
		print_r($v);
		$result = ob_get_clean();
		self::log($description . ": " . $result);
	}
}