<?php

require_once 'dbutils.php';
require_once 'config.php';
defined('DB') || define ( 'DB','mysql' );

class OsSystem {
	private static function outputEmptyImage() {
		$my_img = imagecreate( 1,1 );
		$background = imagecolorallocate( $my_img, 0, 0, 255 );
		imagecolortransparent($my_img, $background);
		header( "Content-type: image/png" );
		imagepng( $my_img );
		imagecolordeallocate( $my_img,$background );
		imagedestroy( $my_img );
	}
	
	public static function getlogo($pdo) {
		$img = DbUtils::getImageData($pdo, 'logo', null);
		self::outputImage($pdo, $img);
	}
	public static function getprodimage($pdo,$prodid) {
		$img = DbUtils::getImageData($pdo, '', $prodid);
		self::outputImage($pdo, $img);
	}
	
	private static function outputImage($pdo,$imgDataInBase64) {
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Pragma: no-cache");
		header("Expires: Mon, 20 Dec 1998 01:00:00 GMT" );
		header('Content-Type: ' . image_type_to_mime_type(IMAGETYPE_PNG));

		if (!is_null($imgDataInBase64)) {
			$img = base64_decode($imgDataInBase64);
			$php_img = imagecreatefromstring($img);

			imagesavealpha($php_img, true);
			$color = imagecolorallocatealpha($php_img, 0, 0, 0, 127);

			imagepng($php_img, NULL);
			imagecolordeallocate( $php_img,$color );
			imagedestroy($php_img);
			return;
		}
		self::outputEmptyImage();
	}
	
	public static function getcss($pdo) {
		$guesttheme = DbUtils::getConfigItem($pdo,"guesttheme",8);
		
		switch ($guesttheme) {
			case 0:
				$cssFile = "orderstyle.min.css";
				break;
			case 1:
				$cssFile = "orderstyle-pale.min.css";
				break;
			case 2:
				$cssFile = "orderstyle-darksoul.min.css";
				break;
			case 3:
				$cssFile = "orderstyle-stylisch.min.css";
				break;
			case 4:
				$cssFile = "orderstyle-bluethunder.min.css";
				break;
			case 5:
				$cssFile = "orderstyle-cool.min.css";
				break;
			case 6:
				$cssFile = "orderstyle-pinklady.min.css";
				break;
			case 7:
				$cssFile = "orderstyle-greenfield.min.css";
				break;
			case 8:
				$cssFile = "orderstyle-brightenergy.min.css";
				break;
			default:
				$cssFile = "orderstyle-brightenergy.min.css";
				break;
		}
		
		$cssMobileFile = "3rdparty/orderstyle/" . $cssFile;
		header('Content-type: text/css');
    
		readfile($cssMobileFile);
	}
	private static function checkIndividualFileWriteStatus($filename) {
		if (file_exists($filename)) {
			if (is_writable($filename)) {
				return array("writeable" => 1);
			} else {
				return array("writeable" => 0,"file" => "Datei $filename nicht beschreibbar", "reason" => '');
			}
		} else {
			return array("writeable" => 1);
		}
	}
	private static function checkFileDbWriteStatus() {
		$dir = dirname(__FILE__) . '/../db';
		if (!file_exists($dir)) {
			return array("writeable" => 0,"file" => $dir, "reason" => "Verzeichnis existiert nicht");
		} else if (!is_writable($dir)) {
			return array("writeable" => 0,"file" => $dir, "reason" => '');
		}
		$filesToCheck = array(STATUS_FILE,OSSYSTEM_FILE,IMAGES_FILE,QUEUE_FILE);
		foreach ($filesToCheck as $aFile) {
			$filename = $dir . '/' . $aFile;
			$writeStatus = self::checkIndividualFileWriteStatus($filename);
			if ($writeStatus["writeable"] == 0) {
				return $writeStatus;
			}
		}
		return array("writeable" => 1);
	}
	
	public static function getsystemstatus($pdo) {
		$timezone = DbUtils::getConfigItem($pdo, "timezone", "Europe/Berlin");
		date_default_timezone_set($timezone);

		$writeStatus = array("writeable" => 1);
		$lastaccess = null;
		if (DB == "mysql") {
			$sql = "SELECT date FROM %gueststatus% WHERE item=?";
			$result = DbUtils::fetchSqlAll($pdo, $sql, array('lastosaccess'));

			if (count($result) > 0) {
				$lastaccess = $result[0]["date"];
			}
		} else {
			try {
				$writeStatus = self::checkFileDbWriteStatus();
				$lastaccess = file_get_contents("../db/" . STATUS_FILE);
			} catch (Exception $ex) {
				$lastaccess = null;
			}
		}
		

		$date = new DateTime();
		$currentTimeStamp = $date->getTimestamp();

		if (!is_null($lastaccess)) {
			if (($currentTimeStamp - $lastaccess) > 60) {
				$lastaccessok = 0;
			} else {
				$lastaccessok = 1;
			}
		} else {
			$lastaccessok = 0;
		}

		return array("status" => "OK","msg" => array("lastaccessok" => $lastaccessok,"dbwritestatus" => $writeStatus));
	}
}

if (isset($_GET["command"])) {
	$command = $_GET["command"];
	
	$pdo = null;
	if (DB == "mysql") {
		$pdo = DbUtils::openDbAndReturnPdoStatic();
	}
	
	switch ($command) {
		case "getsystemstatus":
			$ret = OsSystem::getsystemstatus($pdo);
			echo json_encode($ret);
			break;
		case "getlogo":
			OsSystem::getlogo($pdo);
			break;
		case "getprodimage":
			OsSystem::getprodimage($pdo,$_GET["prodid"]);
			break;
		case "getcss":
			OsSystem::getcss($pdo);
			break;
		default:
			break;
	}
}

