<?php

require_once __DIR__ . '/IQueueStorage.php';

class QueueStorageFile implements IQueueStorage {
        private array $queueItems = array();
        private string $filename = "";
        
        public function __construct() {
                $this->filename = dirname(__FILE__) . '/../../db/' . QUEUE_FILE;
        }

        public function precheck() {

        }
        
        public function begin() {
                try {
                        $this->queueItems = array();
                        if (file_exists($this->filename)) {
                                $queueItemsFileContent = file_get_contents($this->filename);
                                $this->queueItems = json_decode($queueItemsFileContent,true);
                        }
                } catch (Exception $ex) {
                        error_log("File access to " . $this->filename . " failed: " . $ex->getMessage());
                        $this->queueItems = array();
                }
        }
        public function complete() {
                
        }
        
        public function addOrderIntoDb(string $ordertime,array $anOrder,string $extrasInJson,string $tableid,?string $tablecode,?string $dailycode) : bool {
                try {
                        $prodid = $anOrder["prodid"];
                        $this->queueItems[] = array("date" => $ordertime,"prodid" => $prodid,"tableid" => $tableid, "tablecode" => $tablecode, "dailycode" => $dailycode, "extrasinjson" => $extrasInJson);
                        file_put_contents($this->filename, json_encode($this->queueItems));
                        DbUtils::log("Add product with id $prodid to file queue");
                        return true;
                } catch (Exception $ex) {
                        error_log("Writing orders to file " . $this->filename . " failed: " . $ex->getMessage());
                        return false;
                }
        }
}