#!/bin/bash

# Die folgenden Werte müssen je nach Installation angepasst werden:

mount="/dev/sdc1"
database="ordersprinter"
user="Benutzer"
password="DasPasswort"
serverbase="http://localhost/ordersprinter"
remoteaccesscode="123"
format="osb"

if grep -qs "$mount" /proc/mounts; then
  echo "Der USB-Stick ist bereits eingehaengt."
else
  echo "Der USB-Stick ist noch nicht eingehaengt."
  mount "$mount" /mnt
  if [ $? -ne 0 ]; then
   echo "Der USB-Stick konnte nicht eingehaengt werden, das Backup ist nicht erfolgt!"
   exit 1
  fi
fi

# Halte die letzten 3 Sicherungen der DB vor:
if [ -f /mnt/db-dump-1.$format ]
 then mv /mnt/db-dump-1.$format /mnt/db-dump-2.$format
fi
if [ -f /mnt/db-dump.$format ]
 then mv /mnt/db-dump.$format /mnt/db-dump-1.$format
fi
   
# Halte die letzten 3 Sicherungen des Kassenbuchs vor
if [ -f /mnt/kassenbuch-1.pdf ]
 then mv /mnt/kassenbuch-1.pdf /mnt/kassenbuch-2.pdf
fi
if [ -f /mnt/kassenbuch.pdf ]
 then mv /mnt/kassenbuch.pdf /mnt/kassenbuch-1.pdf
fi
   
#
# Sicherung der Datenbank über die OrderSprinter Backup-Funktion
# (das ist die bevorzugte Variante, weil die Ausgabe-Datei wieder über die Wiederherstellungsfunktion
# vom OrderSprinter eingelesen werden kann).
#
#
wget --post-data "remoteaccesscode=$remoteaccesscode" -O /mnt/db-dump.$format 2>>/dev/null "$serverbase/php/contenthandler.php?module=admin&command=autobackup"
#
#
# Sicherung der Datenbank direkt über mysqldump:
# (wird diese Variante genutzt, ist das Umkopieren anzupassen, wenn mehrere Datensicherungen aufbewahrt
# werden sollen.)
#
#mysqldump --user=$user --password=$password --databases $database > /mnt/db-dump.sql

#
# Sicherung des Kassenbuchs als PDF
wget --post-data "remoteaccesscode=$remoteaccesscode" -O /mnt/kassenbuch.pdf 2>>/dev/null "$serverbase/php/contenthandler.php?module=bill&command=autoBackupPdfSummary&lang=0"
#
   
echo "Das Datenbank-Backup ist erfolgt."

umount /mnt
if [ $? -eq 0 ]; then
  echo "Der USB-Stick wurde ausgehaengt."
else
  echo "Der USB-Stick konnte jedoch nicht ausgehaengt werden."
  exit 1
fi

exit 0