<?php
error_reporting(E_ALL);
require_once ('../php/dbutils.php');
require_once ('../php/globals.php');
require_once ('../php/config.php');
require_once ('../php/database/database.php');

class DbConfig {
	
	/**
	 * Return the basic configuration that is needed to access the database and its content.
	 */
	static function getConfigVals() {
		$retArray = array(
				"host" => MYSQL_HOST,
				"db" => MYSQL_DB,
				"user" => MYSQL_USER,
				"password" => MYSQL_PASSWORD,
				"tabprefix" => TAB_PREFIX);
		echo json_encode(array("status" => "OK","result" => $retArray));
	}
	
	/**
	 * Write the file php/config.php
	 * 
	 * @param unknown $host
	 * @param unknown $db
	 * @param unknown $user
	 * @param unknown $password
	 * @param unknown $prefix
	 */
	static function writeConfigFile($host,$db,$user,$password,$prefix) {
		$configFile = "../php/config.php";
		if (is_file($configFile) and !is_writable($configFile)) {
			return array("status" => "ERROR","msg" => "The configuration file does not exist or cannot be overwritten!");
		}
		try {
			$errorlevel = "<?php\nerror_reporting(E_ALL);\n\n";
			$hostlines = "// Zum Aufbau der Verbindung zur Datenbank\n";
			$hostlines .= "// die Daten erhalten Sie von Ihrem Provider\n";
			$hostlines .= "define ( 'MYSQL_HOST','$host' );";
			$userlines = "define ( 'MYSQL_USER',  '$user' );";
			$dbpasslines = "define ( 'MYSQL_PASSWORD',  '$password' );";
			$dblines = "define ( 'MYSQL_DB', '$db' );";
			$dbloglines = "define ( 'LOG', false );";
			$prefixlines = "define ('TAB_PREFIX', '$prefix');";
			$installstatusline = "define ('INSTALLSTATUS', 'installed');";
			$configText = "$errorlevel\n$hostlines\n$userlines\n$dbpasslines\n$dblines\n$dbloglines\n$prefixlines\n$installstatusline\n?>";
			file_put_contents($configFile, $configText);
			return array("status" => "OK");
		} catch (Exception $e) {
			// Directory or file not writeable
			return array("status" => "ERROR","msg" => "The exception during installation: " . $e);
		}
	}
}


class Installer {

	/**
	 * Start a fresh installation! This means:
	 * - write the config.php
	 * - create the data base tables
	 * - fill initial values in the data base like version and access parameter
	 * 
	 * @param unknown $host
	 * @param unknown $dbname
	 * @param unknown $user
	 * @param unknown $pass
	 * @param unknown $prefix
	 * @param unknown $adminpass
	 * @return boolean
	 */
	static function install($host,$dbname,$user,$pass,$prefix,$adminpass) {
		$configstatus = DbConfig::writeConfigFile($host,$dbname,$user,$pass,$prefix);
		if ($configstatus["status"] != "OK") {
			return $configstatus;
		}

		$pdo = Database::openDbAndReturnPdo($host,$dbname,$user,$pass);
		
		if (is_null($pdo)) {
			return array("status" => "ERROR","msg" => "Database connection not possible. Is PDO extension installed for PHP?");
		}
		Database::dropTables($pdo);
		Database::createEmptyTables($pdo, $prefix);
		Database::setVersion($pdo,$prefix,"2.9.12");
		Database::setAccessPassword($pdo,$prefix,$adminpass);
		Database::setRefreshRate($pdo,$prefix,"5"); // default: 5 times per hour
		return array("status" => "OK","msg" => "Installation successful");
	}
}

// This is the command that is send via GET in the URL
$command = $_GET["command"];

if ($command == 'getConfig') {
	// to be displayed on the install page as start parameters - fetched from the config.php
	DbConfig::getConfigVals();
} else if ($command == 'install') {
	// start a fresh installation
	$ok = Installer::install($_POST['host'],$_POST['db'],$_POST['user'],$_POST['password'],$_POST['prefix'],$_POST['adminpass']);
	
	if ($ok["status"] == "OK") {
		// log out all users, i.e. kill all existing sessions
		if(session_id() == '') {
			session_start();
		}
		
		$_SESSION = array();

		session_destroy();
		
		// Swipe via memory
		if (ini_get("session.use_cookies")) {
			// Prepare and swipe cookies
			$params = session_get_cookie_params();
			// clear cookies and sessions
			setcookie(session_name(), '', time() - 42000,
			$params["path"], $params["domain"],
			$params["secure"], $params["httponly"]
			);
		}
		
		// kill all sessions - but does not seem to work correctly...
		ini_set('session.gc_max_lifetime', 0);
		ini_set('session.gc_probability', 1);
		ini_set('session.gc_divisor', 1);
	
		echo json_encode($ok);
	} else {
		echo json_encode($ok);
	}
} else if ($command == 'update') {
	// to be filled when next version is available
}