/**
 * Set of clients
 */

function ClientDetails () {
	//
};

/**
 * the selected client id - needed statically for cyclic refresh
 */
ClientDetails.selectedClientId = null;

/**
 * Save the status of the messages are inserted in the UI. They should not
 * be overwritten with each cyclic refresh, so that user inputs won't be
 * overwritten.
 */
ClientDetails.messagesInserted = false;

/**
 * Selection box at which the user can select the client.
 * This method also binds the change event, i.e. the function that is called
 * once the user has changed the selection.
 * 
 * @param clients
 * @param htmlid
 */
ClientDetails.createSelectionBox = function(clients,htmlid) {
	$("#detailstabs").tabs();
	var html = "";
	if (clients.length == 0) {
		html = "Es wurden noch keine Betriebe eingegeben.";
	} else {
		ClientDetails.selectedClientId = clients[0].id;
		ClientDetails.requestReport(clients[0].id);
		
		html = "<select style='color:green;height:60px;background-color:Lavender;'>";
		for (var i=0;i<clients.length;i++) {
			var client = clients[i];
			html += "<option id='option_client_" + client.id + "' value='" + client.id + "'>" + client.name + "</option>";
		}
	}
	$(htmlid).html("Auswahl Betrieb: " + html);
	
	// handle a change
	$(htmlid).change(function() {
		var clientid = $( htmlid + " option:selected" ).val();
		ClientDetails.selectedClientId = clientid;
		ClientDetails.requestReport(clientid);
 	});
	
	// handle button events for the selected client
	$("#delLoginMessage").on("click", function (e) {
		$("#loginmsg").val("");
		ClientDetails.sendMessage(e,"","sendloginmessage");
	});
	$("#sendLoginMessage").on("click", function (e) {
		ClientDetails.sendMessage(e,$("#loginmsg").val(),"sendloginmessage");
	});
	$("#delWaiterMessage").on("click", function (e) {
		$("#waitermsg").val("");
		ClientDetails.sendMessage(e,"","sendwaitermessage");
	});
	$("#sendWaiterMessage").on("click", function (e) {
		ClientDetails.sendMessage(e,$("#waitermsg").val(),"sendwaitermessage");
	});
};

/**
 * Send a message as login or waiter message to the client. If the message is an
 * empty string it works as if the message has to be deleted.
 * @param e
 * @param message
 * @param command
 */
ClientDetails.sendMessage = function(e,message,command) {
	e.stopImmediatePropagation();
	e.preventDefault();
	if (ClientDetails.selectedClientId != null) {
		var msg = "";
		var data = {
			clientid:ClientDetails.selectedClientId,
			message:message
			};
	
		doAjaxTransmitValue("POST","php/datacollector.php?command=" + command,data,null,data,null);
	}
}

ClientDetails.requestReport = function(clientid) {
	$("#hourlytablearea").html("");
	
	var data = {
			clientid:clientid,
			action:"report"
			};
	doAjaxTransmitValue("POST","php/datacollector.php?command=getreport",data,ClientDetails.insertClientValue,data,null);
	
	if (!ClientDetails.messagesInserted) {
		$("#loginmsg").val("");
		$("#waitermsg").val("");
		
		var data = { clientid:clientid,action:"getwaitermessage" };
		doAjaxTransmitValue("POST","php/datacollector.php?command=getwaitermessage",data,ClientDetails.insertClientMessage,data,null);
	
		var data = { clientid:clientid,action:"getloginmessage" };
		doAjaxTransmitValue("POST","php/datacollector.php?command=getloginmessage",data,ClientDetails.insertClientMessage,data,null);
		
		ClientDetails.messagesInserted = true;
	}
};

ClientDetails.updateReport = function() {
	var clientid = ClientDetails.selectedClientId;
	if (clientid != null) {
		ClientDetails.requestReport(clientid);
	}
};

ClientDetails.insertClientValue = function(answer,data) {
	if (data.action == "report") {
		// has no status
		
		// first calculate the max value
		var today = answer.today.content;
		var i=0;
		var max = 0.0;
		for (i=0;i<today.length;i++) {
			var sum = parseFloat(today[i].sum);
			if (sum > max) {
				max=sum;
			}
		}
		var html = "<table class=genTable width='100%'>";
		html += "<tr><th>Stunde<th>Einnahme<th width='70%'>Visuelle Anzeige</tr>";
		
		for (i=0;i<today.length;i++) {
			var hour = today[i].iter;
			var sum = parseFloat(today[i].sum);
			var formattedSum = sum.toFixed(2).replace(".",",");
			
			var width = 0.0;
			if (max != 0.0) {
				width = sum/max * 98.0;
			}
			var graph = "<img src=img/green.png style='height:20px;width:" + width + "%;' />";
			html += "<tr><td>" + hour + "<td>" + formattedSum + "<td>" + graph + "</tr>";
		}
		html += "</table>";
		$("#hourlytablearea").html(html);
	}
};


ClientDetails.insertClientMessage = function(answer,data) {
	if (answer.status == 1) {
		var msg = answer.message;
		var id = "";
		if (data.action == "getloginmessage") {
			$("#loginmsg").val(msg);
		} else if (data.action == "getwaitermessage") {
			$("#waitermsg").val(msg);
		}
	}
}