/**
 * Set of clients
 */

function ClientInfo () {
	//
};

/**
 * Create the table of all clients and fill this table with the overall information
 * about the current status like how many open tables etc.
 * 
 * @param clients
 * @param htmlid
 */
ClientInfo.showInfoOfAllClients = function(clients,htmlid) {
	var html = "";
	if (clients.length == 0) {
		html = "Es wurden noch keine Betriebe eingegeben.";
	} else {
		// create a table framework, that can later be dynamically filled by data
		html = "<table class=genTable><tr><th>&nbsp;<th colspan=" + clients.length + ">Betriebe</tr><tr><th>&nbsp;";
		var i=0;
		for (i=0;i<clients.length;i++) {
			var client = clients[i];
			html += "<th>" + client.name;
		}
		html += "</tr>";
		// the header is now completed
		
		html += ClientInfo.createHtmlRow(clients,"Softwareversion","Version");
		html += ClientInfo.createHtmlRow(clients,"Offene Rechnungen","OpenBills");
		html += ClientInfo.createHtmlRow(clients,"Noch nicht abgerechnete Tische","OpenTables");
		html += ClientInfo.createHtmlRow(clients,"Letzter Tagesabschluss","LastClosing");

		html += "</table>";
		for (var i=0;i<clients.length;i++) {
			var client = clients[i];
			
		}
	}
	$(htmlid).html(html);
	ClientInfo.requestDataOfClients(clients);
};

/**
 * Request the clients information (open tables, not paid sum, version) in the table that
 * was created by showInfoOfAllClients
 * 
 * To prevent problems with the "same origin policy" the data of the different clients is
 * fetched by a php process on the server.
 * 
 * @param clients
 */
ClientInfo.requestDataOfClients = function(clients) {
	var html = "";
	if (clients.length > 0) {
		var i=0;
		for (i=0;i<clients.length;i++) {
			var client = clients[i];
			
			// version info of the clients
			var data = {
					clientid:client.id,
					action:"version"
					};
			doAjaxTransmitValue("POST","php/datacollector.php?command=getclientversion",data,ClientInfo.insertClientValue,data,null);
			
			// sum of the last closing
			data = {
					clientid:client.id,
					number:1,
					action:"lastclosing"
					};
			doAjaxTransmitValue("POST", "php/datacollector.php?command=getlastclosings", data, ClientInfo.insertClientValue, data, null);
		
			// getOpenTables: how many tables are in the pipeline to pay and how much 
			data = {
					remoteaccesscode: client.remoteaccesscode,
					clientid:client.id,
					action:"opentables"
					};
			doAjaxTransmitValue("POST", "php/datacollector.php?command=getopentables", data, ClientInfo.insertClientValue, data, null);
		}
	}
};

/**
 * Handle the answer of a specific call (e.g.  get version) of one client and insert
 * the received value into the correct table cell.
 * 
 * @param answer
 * @param data
 */
ClientInfo.insertClientValue = function(answer,data) {
	if (answer.status == 1) {
		if (data.action == "version") {
			$("#Version_" + data.clientid).html(answer.version);
		} else if (data.action == "lastclosing") {
			var sum = parseFloat(answer.closings[0].billsum);
			var formattedSum = sum.toFixed(2).replace(".",",");
			$("#LastClosing_" + data.clientid).html(formattedSum);
		} else if (data.action == "opentables") {
			var formattedSum = answer.sum.toFixed(2).replace(".",",");
			$("#OpenBills_" + data.clientid).html(formattedSum);
			$("#OpenTables_" + data.clientid).html(answer.opentables);
		}
	}
};

/**
 * Prepare a table row for a specific item (e.g. version) with columns
 * for all configured clients.
 * 
 * @param clients
 * @param rowTitle
 * @param rowId
 * @returns {String}
 */
ClientInfo.createHtmlRow = function(clients,rowTitle,rowId) {
	var html = "<tr><td class='topic'>" + rowTitle;
	for (var i=0;i<clients.length;i++) {
		var client = clients[i];
		html += "<td id=" + rowId + "_" + client.id + " style='text-align:right;'>&nbsp;";
	}
	return html + "</tr>";
}