<?php
require_once ('config.php');
require_once ('database/database.php');
require_once ('globals.php');
require_once ('utils.php');


if (!isUserLoggedInCore()) {
	return;
}

$command = $_GET["command"];

if ($command == 'createclient') {
	createclient($_POST['name'],$_POST['url'],$_POST['code'],$_POST['basicauthuser'],$_POST['basicauthpass'],$_POST['remark']);
} else if ($command == 'deleteclient') {
	deleteclient($_POST['id']);
} else if ($command == 'changeclient') {
	changeclient($_POST['id'],$_POST['name'],$_POST['url'],$_POST['code'],$_POST['basicauthuser'],$_POST['basicauthpass'],$_POST['remark']);
} else if ($command == 'getallclients') {
	getallclients();
} else if ($command == 'saveclients') {
	saveclients();
} else if ($command == 'readclients') {
	readclients();
}

/**
 * Fetch the parameters of all clients from the data base
 */
function getallclients() {
	$pdo = DbUtils::openDbAndReturnPdo();
	$sql = "SELECT * FROM %clients%";
	$stmt = $pdo->prepare(DbUtils::substTableAlias($sql));
	$stmt->execute();
	echo json_encode($stmt->fetchAll());
}

/**
 * Create en entry for a new client in the database if the client does not exist already.
 * The existence is tested by checking the name and the url.
 * 
 * @param unknown $name a name for the client
 * @param unknown $url the http address of the client
 * @param unknown $code the remote access code
 * @param unknown $basicAuthUser user of basic authentication
 * @param unknown $basicAuthPass password for basic authentication
 * @param unknown $remark a remark for the client that can be set by the user
 */
function createclient($name,$url,$code,$basicAuthUser,$basicAuthPass,$remark) {
	$pdo = DbUtils::openDbAndReturnPdo();
	$pdo->beginTransaction();
	$sql = "SELECT id FROM %clients% WHERE name=? OR url=?";
	$stmt = $pdo->prepare(DbUtils::substTableAlias($sql));
	$stmt->execute(array($name,$url));
	$foundSameClients = $stmt->rowCount();
	if ($foundSameClients > 0) {
		$pdo->rollBack();
		echo json_encode(array("status" => array(ERROR_CLIENT_EXISTS,ERROR_CLIENT_EXISTS_MSG)));
		return;
	}
	
	// at this point it is checked that the client does not exist and thus is can be inserted as new client
	$sql = "INSERT INTO %clients% (`id` , `name`,`url`,`remoteaccesscode`,`basicauthuser`,`basicauthpass`,`remark`) VALUES (NULL,?,?,?,?,?,?)";
	$stmt = $pdo->prepare(DbUtils::substTableAlias($sql));
	$stmt->execute(array($name,$url,$code,$basicAuthUser,$basicAuthPass,$remark));
	$pdo->commit();
	echo json_encode(array("status" => array(ACTION_OK,ACTION_OK_MSG)));
}

/**
 * Change the parameters of an existing client in the database
 * 
 * @param unknown $id
 * @param unknown $name
 * @param unknown $url
 * @param unknown $code
 * @param unknown $basicAuthUser
 * @param unknown $basicAuthPass
 * @param unknown $remark
 */
function changeclient($id,$name,$url,$code,$basicAuthUser,$basicAuthPass,$remark) {
	$pdo = DbUtils::openDbAndReturnPdo();
	$pdo->beginTransaction();
	$sql = "SELECT id FROM %clients% WHERE id=?";
	$stmt = $pdo->prepare(DbUtils::substTableAlias($sql));
	$stmt->execute(array($id));
	$foundSameClients = $stmt->rowCount();
	if ($foundSameClients == 0) {
		$pdo->rollBack();
		echo json_encode(array("status" => array(ERROR_CLIENT_EXISTS,ERROR_CLIENT_EXISTS_MSG)));
		return;
	}
	
	$sql = "UPDATE %clients% SET name=?,url=?,remoteaccesscode=?,basicauthuser=?,basicauthpass=?,remark=? WHERE id=?";
	$stmt = $pdo->prepare(DbUtils::substTableAlias($sql));
	$stmt->execute(array($name,$url,$code,$basicAuthUser,$basicAuthPass,$remark,$id));
	$pdo->commit();
	echo json_encode(array("status" => array(ACTION_OK,ACTION_OK_MSG)));
}

/**
 * Delete the client in the data base
 * @param unknown $id
 */
function deleteclient($id) {
	$pdo = DbUtils::openDbAndReturnPdo();
	$pdo->beginTransaction();
	$sql = "SELECT id FROM %clients% WHERE id=?";
	$stmt = $pdo->prepare(DbUtils::substTableAlias($sql));
	$stmt->execute(array($id));
	$foundSameClients = $stmt->rowCount();
	if ($foundSameClients == 0) {
		$pdo->rollBack();
		echo json_encode(array("status" => array(ERROR_CLIENT_DOES_NOT_EXIST,ERROR_CLIENT_DOES_NOT_EXIST_MSG)));
		return;
	}
	
	$sql = "DELETE FROM %clients% WHERE id=?";
	$stmt = $pdo->prepare(DbUtils::substTableAlias($sql));
	$stmt->execute(array($id));
	$pdo->commit();
	echo json_encode(array("status" => array(ACTION_OK,ACTION_OK_MSG)));
}

/**
 * Fetch the information about all configured clients from the database and
 * return it as a json stream for download by the user.
 */
function saveclients() {
	$pdo = DbUtils::openDbAndReturnPdo();
	$sql = "SELECT * FROM %clients%";
	$stmt = $pdo->prepare(DbUtils::substTableAlias($sql));
	$stmt->execute();
	$retStr = json_encode($stmt->fetchAll(PDO::FETCH_ASSOC));
	
	header("Pragma: public");
	header("Expires: 0");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("Cache-Control: public");
	header("Content-Description: File Transfer");
	header("Content-type: application/octet-stream");
	header("Content-Disposition: attachment; filename=\"backup-clients.json\"");
	header("Content-Transfer-Encoding: binary");
	header("Content-Length: ". strlen($retStr));
	
	echo $retStr;
}

/**
 * Read in a json file with the set of clients and save them in the 
 * database as a new set.
 * 
 */
function readclients() {
	if ($_FILES['userfile']['error'] != UPLOAD_ERR_OK               //checks for errors
			&& is_uploaded_file($_FILES['userfile']['tmp_name'])) { //checks that file is uploaded
		header("Location: ../infopage.html?e=overview.php=Kann_Datei_nicht_laden.");
		exit();
	}

	if(!file_exists($_FILES['userfile']['tmp_name']) || !is_uploaded_file($_FILES['userfile']['tmp_name'])) {
		header("Location: ../infopage.html?e=overview.php=Datei_nicht_angegeben.");
		exit();
	}

	$content = json_decode(file_get_contents($_FILES['userfile']['tmp_name']));

	$pdo = DbUtils::openDbAndReturnPdo();
	$pdo->beginTransaction();
	$sql = "DELETE FROM %clients%";
	$stmt = $pdo->prepare(DbUtils::substTableAlias($sql));
	$stmt->execute();
	foreach ($content as $client) {
		$sql = "INSERT INTO %clients% (`id` , `name`,`url`,`remoteaccesscode`,`basicauthuser`,`basicauthpass`,`remark`) VALUES (NULL,?,?,?,?,?,?)";
		$stmt = $pdo->prepare(DbUtils::substTableAlias($sql));
		$stmt->execute(array($client->name,$client->url,$client->remoteaccesscode,$client->basicauthuser,$client->basicauthpass,$client->remark));
	}
	$pdo->commit();

	header("Location: ../infopage.html?i=overview.php=Import_war_erfolgreich."); /* Browser umleiten */
	exit;
}
